# This R script makes use of tSNE co-ordinates and clusters identity files (clusters.txt) obtained from Race-ID-StemID protocol
# to generate cluster-wise coloured plots for Kat2a-WT and Kat2a-KO cells as shown in Fig 4A.

tsne_cord<-read.table("tsne_cord.txt",header=TRUE,quote="")
clusters<-read.table("clusters.txt",header=TRUE,quote="")
max_clust<-max(clusters[,2])

# For Kat2a-KO cells
colors<-rainbow(max(clusters[,2]))
x<-which(clusters[,2]==1)
print(paste(x,x))
p<-which(x <= 2477)
print(p)
plot(tsne_cord[x[p],2],tsne_cord[x[p],3],xlim=c(min(tsne_cord[,2]),max(tsne_cord[,2])),ylim=c(min(tsne_cord[,3]),max(tsne_cord[,3])),col=colors[1],pch=1,xlab="tSNE 1",ylab="tSNE 2",main="Kat2a-NULL clusters")
for (i in 1:(max_clust-1)){
x<-which(clusters[,2]==i+1)
print(x)
p<-which(x <= 2477)
print(p)
points(tsne_cord[x[p],2],tsne_cord[x[p],3],col=colors[i+1],pch=1)
}
legend("topright",legend=1:12,col=colors,pch=1)

# For Kat2a-WT cells
colors<-rainbow(max(clusters[,2]))
x<-which(clusters[,2]==1)
p<-which(x > 2477)
print(p)
plot(tsne_cord[x[p],2],tsne_cord[x[p],3],xlim=c(min(tsne_cord[,2]),max(tsne_cord[,2])),ylim=c(min(tsne_cord[,3]),max(tsne_cord[,3])),col=colors[1],pch=1,xlab="tSNE 1",ylab="tSNE 2",main="Kat2a-WT clusters")
for (i in 1:(max_clust-1)){
x<-which(clusters[,2]==i+1)
print(x)
p<-which(x > 2477)
print(p)
points(tsne_cord[x[p],2],tsne_cord[x[p],3],col=colors[i+1],pch=1)
}
legend("topright",legend=1:12,col=colors,pch=1)

